PaintVehicleConfig = {}

PaintVehicleConfig.COEF_TIME_SAND = 1.2
PaintVehicleConfig.COEF_USE_PRIMER = 0.67
PaintVehicleConfig.COEF_USE_SPRAY_GUN = 0.85

--- The vehicle areas' ids starting from the engine in counterclockwise order.
PaintVehicleConfig.VEHICLE_AREAS = {
    "Engine", "SeatFrontLeft", "TruckBed", "SeatFrontRight"
}

--- List of all item types used by the mod.
PaintVehicleConfig.ITEMS = {
    -- Vanilla items
    DUST_MASK = "Base.Hat_DustMask",
    GOGGLES = "Base.Glasses_SafetyGoggles",
    GAS_MASK = "Base.Hat_GasMask",
    BIO_MASK = "Base.Hat_NBCmask",
    -- Mod's items
    CATALOGUE_SPRAYS = "PaintYourRide.CataloguePaintSpray",
    CATALOGUE_TINTS = "PaintYourRide.CataloguePaintTints",
    SPRAY_GUN = "PaintYourRide.SprayGun",
    WIRE_BRUSH = "PaintYourRide.WireBrush",
    BASE_PAINT = "PaintYourRide.AutomotivePaintWhite",
    PRIMER = "PaintYourRide.AutomotiveSprayPrimer",
    TINTS = {
        RED = "PaintYourRide.AutomotiveTintPaintRed",
        YELLOW = "PaintYourRide.AutomotiveTintPaintYellow",
        GREEN = "PaintYourRide.AutomotiveTintPaintGreen",
        CYAN = "PaintYourRide.AutomotiveTintPaintCyan",
        BLUE = "PaintYourRide.AutomotiveTintPaintBlue",
        MAGENTA = "PaintYourRide.AutomotiveTintPaintMagenta",
        BLACK = "PaintYourRide.AutomotiveTintPaintBlack"
    },
    SPRAY_PAINT = {
        { itemType = "AutomotiveSprayPaintBlack", color = { 0, 4, 21 } },
        { itemType = "AutomotiveSprayPaintBlue", color = { 59.6, 91, 66 } },
        { itemType = "AutomotiveSprayPaintBlueNavy", color = { 66.7, 100, 50 } },
        { itemType = "AutomotiveSprayPaintBlueNeon", color = { 52.5, 98, 100 } },
        { itemType = "AutomotiveSprayPaintBlueOlympic", color = { 55, 100, 80 } },
        { itemType = "AutomotiveSprayPaintBrownDarkChocolate", color = { 7.2, 97, 24 } },
        { itemType = "AutomotiveSprayPaintBrownRusty", color = { 5.5, 98, 55 } },
        { itemType = "AutomotiveSprayPaintGreen", color = { 27, 100, 48 } },
        { itemType = "AutomotiveSprayPaintGreenArmy", color = { 25.4, 67, 34 } },
        { itemType = "AutomotiveSprayPaintGreenForest", color = { 37.7, 89, 40 } },
        { itemType = "AutomotiveSprayPaintGreenNeon", color = { 29, 100, 90 } },
        { itemType = "AutomotiveSprayPaintGrey", color = { 15, 0, 73 } },
        { itemType = "AutomotiveSprayPaintGreySteel", color = { 57.2, 6, 49 } },
        { itemType = "AutomotiveSprayPaintOrangeTangerine", color = { 6.6, 100, 100 } },
        { itemType = "AutomotiveSprayPaintPinkBubbleGum", color = { 91.6, 64, 100 } },
        { itemType = "AutomotiveSprayPaintPinkGlamorous", color = { 83, 85, 100 } },
        { itemType = "AutomotiveSprayPaintRed", color = { 0.2, 95, 70 } },
        { itemType = "AutomotiveSprayPaintRedBurgundy", color = { 96.4, 99, 55 } },
        { itemType = "AutomotiveSprayPaintRedCandyApple", color = { 0.5, 100, 100 } },
        { itemType = "AutomotiveSprayPaintVioletGrape", color = { 75.5, 73, 66 } },
        { itemType = "AutomotiveSprayPaintVioletIndigo", color = { 76.4, 100, 51 } },
        { itemType = "AutomotiveSprayPaintWhite", color = { 15, 8, 88 } },
        { itemType = "AutomotiveSprayPaintYellow", color = { 15.8, 100, 90 } },
        { itemType = "AutomotiveSprayPaintYellowNeon", color = { 19.7, 98, 100 } },
        { itemType = "AutomotiveSprayPaintYellowTuscany", color = { 12.4, 100, 100 } }
    }
}

local vehiclesVanilla = {
    -- Standard
    { vehicleId = "Base.CarNormal", paintRequired = 30 },
    { vehicleId = "Base.CarStationWagon2", paintRequired = 32 },
    { vehicleId = "Base.OffRoad", paintRequired = 25 },
    { vehicleId = "Base.SmallCar", paintRequired = 21 },
    { vehicleId = "Base.SmallCar02", paintRequired = 26 },
    -- Sports
    { vehicleId = "Base.CarLuxury", paintRequired = 32 },
    { vehicleId = "Base.ModernCar", paintRequired = 30 },
    { vehicleId = "Base.ModernCar02", paintRequired = 30 },
    { vehicleId = "Base.SportsCar", paintRequired = 22 },
    -- Heavy-Duty
    { vehicleId = "Base.PickUpTruck", paintRequired = 31 },
    { vehicleId = "Base.PickUpVan", paintRequired = 35 },
    { vehicleId = "Base.StepVan", paintRequired = 45 },
    { vehicleId = "Base.SUV", paintRequired = 33 },
    { vehicleId = "Base.Van", paintRequired = 42 },
    { vehicleId = "Base.VanSeats", paintRequired = 38 },
}

local vehiclesFRUsedCars = {
    -- Standard
    { vehicleId = "Base.65gto", paintRequired = 27 },
    { vehicleId = "Base.68elcamino", paintRequired = 28 },
    { vehicleId = "Base.68wildcat", paintRequired = 28 },
    { vehicleId = "Base.68wildcatconvert", paintRequired = 23 },
    { vehicleId = "Base.69charger", paintRequired = 27 },
    { vehicleId = "Base.70chevelle", paintRequired = 27 },
    { vehicleId = "Base.70elcamino", paintRequired = 28 },
    { vehicleId = "Base.71impala", paintRequired = 30 },
    { vehicleId = "Base.73falcon", paintRequired = 26 },
    { vehicleId = "Base.73pinto", paintRequired = 20 },
    { vehicleId = "Base.79brougham", paintRequired = 29 },
    { vehicleId = "Base.85vicsed", paintRequired = 29 },
    { vehicleId = "Base.85vicwag", paintRequired = 30 },
    { vehicleId = "Base.85vicwag2", paintRequired = 30 },
    { vehicleId = "Base.86yugo", paintRequired = 18 },
    { vehicleId = "Base.91crx", paintRequired = 19 },
    { vehicleId = "Base.volvo244", paintRequired = 25 },
    -- Heavy-Duty
    { vehicleId = "Base.87blazer", paintRequired = 33 },
    { vehicleId = "Base.87c10lb", paintRequired = 36 },
    { vehicleId = "Base.87c10sb", paintRequired = 31 },
    { vehicleId = "Base.87c10utility", paintRequired = 19 },
    { vehicleId = "Base.87suburban", paintRequired = 37 },
    { vehicleId = "Base.90ramlb", paintRequired = 34 },
    { vehicleId = "Base.90ramsb", paintRequired = 31 },
    { vehicleId = "Base.astrovan", paintRequired = 33 },
    { vehicleId = "Base.f700box", paintRequired = 25 },
    { vehicleId = "Base.f700dump", paintRequired = 25 },
    { vehicleId = "Base.f700flatbed", paintRequired = 25 },
}

PaintVehicleConfig.VEHICLES = vehiclesVanilla

local function merge(t1, t2)
    for _, v in ipairs(t2) do
        table.insert(t1, v)
    end
end

if getActivatedMods():contains("FRUsedCarsBETA") then
    merge(PaintVehicleConfig.VEHICLES, vehiclesFRUsedCars)
end